

EntityJSEvents.modifyEntity(e => {
    e.modify("minecraft:villager", 修改构建器 => {
        修改构建器.tick(实体 => {
            // 每20个tick (通常是1秒) 执行一次AI逻辑
            if (实体.age % 20 === 0) {
                let 世界 = 实体.level;
                let 村民位置 = 实体.position();
                let 检查半径 = 8.0;
                let 检查半径平方 = 检查半径 * 检查半径;
                let 停止距离 = 3.0;
                let 停止距离平方 = 停止距离 * 停止距离;
                
                let 目标物品ID列表 = ["kubejs:gold_coin", "kubejs:diamond_coin", "kubejs:netherite_coin"];
                let 目标玩家 = null;
                
                let 搜索边界盒 = 实体.getBoundingBox().inflate(检查半径);
                
                let 区域内所有获取到的实体 = 世界.getEntities(null, 搜索边界盒);
                
                let 区域内符合条件的玩家列表 = [];
                if (区域内所有获取到的实体 && 区域内所有获取到的实体.length > 0) {
                    for (let 当前检索实体 of 区域内所有获取到的实体) {
                        // 在JS端进行所有筛选
                        if (当前检索实体 && 当前检索实体.type === "minecraft:player" && 当前检索实体.isAlive() && 当前检索实体.id !== 实体.id) {
                            区域内符合条件的玩家列表.push(当前检索实体);
                        }
                    }
                }
                
                for (let 当前检查玩家 of 区域内符合条件的玩家列表) {
                    if (当前检查玩家.position().distanceToSqr(村民位置) <= 检查半径平方) {
                        let 玩家手持物品 = 当前检查玩家.getMainHandItem();
                        if (目标物品ID列表.includes(玩家手持物品.id)) {
                            目标玩家 = 当前检查玩家;
                            break; 
                        }
                    }
                }

                if (目标玩家 !== null) {
                    let 与玩家距离平方 = 目标玩家.position().distanceToSqr(村民位置);
                    实体.getLookControl().setLookAt(目标玩家.getX(), 目标玩家.getEyeY(), 目标玩家.getZ());
                    
                    if (与玩家距离平方 > 停止距离平方) {
                        实体.getNavigation().moveTo(目标玩家, 0.6);
                    } else {
                        if (!实体.getNavigation().isDone()) {
                            实体.getNavigation().stop();
                        }
                    }
                } else {
                    if (!实体.getNavigation().isDone()) {
                        实体.getNavigation().stop();
                    }
                }
            }
        });
    });
});